<?php
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');

$project_id = $_GET['project_id'] ?? '';
$category = $_GET['category'] ?? 'all';
$brand = $_GET['brand'] ?? '';

$project_id = mysqli_real_escape_string($link, $project_id);
$category = mysqli_real_escape_string($link, $category);
$brand = mysqli_real_escape_string($link, $brand);

// Prepare category condition
$categoryCondition = '';
if ($category !== 'all') {
    $catId = preg_replace('/^cat/', '', $category);
    $catId = mysqli_real_escape_string($link, $catId);
    $categoryCondition = "AND category_id = '$catId'";
}

// Prepare brand condition
$brandCondition = '';
if ($brand !== '') {
    $brandCondition = "AND brand = '$brand'";
}

$query = "SELECT * FROM product WHERE project_id = '$project_id' $categoryCondition $brandCondition ORDER BY pid";

$result = mysqli_query($link, $query);

if (!$result) {
    echo "<p>Error loading products: " . mysqli_error($link) . "</p>";
    exit;
}

if (mysqli_num_rows($result) === 0) {
    echo "<p>No products found.</p>";
    exit;
}

while ($row = mysqli_fetch_assoc($result)) {
    $title = htmlspecialchars($row['title']);
    $image = htmlspecialchars($row['image']);
    $categoryId = htmlspecialchars($row['category_id']);
    $brandName = htmlspecialchars($row['brand']);
    $productId = htmlspecialchars($row['product_id']);
    
    $catClass = 'cat' . $categoryId;
    
    // Try fetching summary if exists
    $summary = '';
    $summaryQuery = "SELECT summary FROM product_data WHERE product_id = '" . mysqli_real_escape_string($link, $productId) . "' LIMIT 1";
    $summaryResult = mysqli_query($link, $summaryQuery);
    if ($summaryResult && mysqli_num_rows($summaryResult) > 0) {
        $summaryRow = mysqli_fetch_assoc($summaryResult);
        $summary = htmlspecialchars($summaryRow['summary']);
    }

    echo '<div class="all ' . $catClass . ' col-xl-4 col-lg-4 col-md-6 mb-40" data-brand="' . $brandName . '">';
    echo '<article class="news__card">';
    echo '<div class="post-item">';
    echo '<div class="featured-container">';
    echo '<div class="featured-wrapper">';
    echo '<a href="product.php?productid=' . $productId . '">';
    echo '<img src="admin/product_img/' . $image . '" alt="' . $title . '" class="img-fluid product-img" />';
    echo '</a></div></div>';
    echo '<div class="news__content">';
    echo '<div class="meta-container">';
    echo '<h3 class="post-title"><a href="product.php?productid=' . $productId . '">' . $title . '</a></h3>';
    echo '<p class="summary-text">' . $summary . '</p>';
    echo '</div></div></div></article></div>';
}
