(function($) {
    "use strict";

    /*-------------------------------------
        Animation on scroll: Number rotator
    -------------------------------------*/
    $("[data-appear-animation]").each(function() {
        var self = $(this);
        var animation = self.data("appear-animation");
        var delay = (self.data("appear-animation-delay") ? self.data("appear-animation-delay") : 0);

        if ($(window).width() > 959) {
            self.html('0');
            self.waypoint(function(direction) {
                if (!self.hasClass('completed')) {
                    var from = self.data('from');
                    var to = self.data('to');
                    var interval = self.data('interval');
                    self.numinate({
                        format: '%counter%',
                        from: from,
                        to: to,
                        runningInterval: 2000,
                        stepUnit: interval,
                        onComplete: function(elem) {
                            self.addClass('completed');
                        }
                    });
                }
            }, { offset: '85%' });
        } else {
            self.html(self.data('to'));
        }
    });

    /*-------------------------------------
        Preloader
    -------------------------------------*/
    $(window).on("load", function(){
        $('#preLoader').fadeOut("slow");
    });

    /*-------------------------------------
    Swiper Slider
    -------------------------------------*/
    var swiperslider = $(".swiper-slider");
    var x = 1;
    swiperslider.each(function() {
        var carouselElement = $(this);
        var columns = $(this).data('columns');
        var loop = $(this).data('loop');
        var autoplay = $(this).data('autoplay');
        var autoplayspeed = $(this).data('autoplayspeed');
        var val_nav = $(this).data('arrows');
        var val_dots = $(this).data('dots');
        var val_center = $(this).data('center');
        var style = $(this).data('effect');
        var loopSlide = null;
        var sl_speed = 300;

        carouselElement.addClass('element-viewtype-carousel-' + x);


        if (columns == '1') {
            var responsive_items = [ /* 1199 : */ '1', /* 991 : */ '1', /* 767 : */ '1', /* 575 : */ '1', /* 0 : */ '1'];
        } else if (columns == '2') {
            var responsive_items = [ /* 1199 : */ '2', /* 991 : */ '2', /* 767 : */ '2', /* 575 : */ '2', /* 0 : */ '1'];
        } else if (columns == '3') {
            var responsive_items = [ /* 1199 : */ '3', /* 991 : */ '2', /* 767 : */ '2', /* 575 : */ '2', /* 0 : */ '1'];
        } else if (columns == '4') {
            var responsive_items = [ /* 1199 : */ '4', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1'];
        } else if (columns == '5') {
            var responsive_items = [ /* 1199 : */ '5', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1'];
        } else if (columns == '6') {
            var responsive_items = [ /* 1199 : */ '6', /* 991 : */ '4', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1'];
        } else {
            var responsive_items = [ /* 1199 : */ '3', /* 991 : */ '3', /* 767 : */ '3', /* 575 : */ '2', /* 0 : */ '1'];
        }

        if (val_dots == true) {
            carouselElement.append('<div class="swiper-pagination swiper-pagination"></div>');
        }
        if (val_nav == true) {
            carouselElement.append('<div class="swiper-buttons"></div>');
            carouselElement.find('.swiper-buttons').append('<div class="swiper-button-next swiper-button-next-' + x + '"></div>');
            carouselElement.find('.swiper-buttons').append('<div class="swiper-button-prev swiper-button-prev-' + x + '"></div>');
        }

        var pagination_val = false;
        if (val_dots == true) {
            pagination_val = {
                el: '.swiper-pagination',
                clickable: true,
            };
        }
        var navigation_val = false;
        if (val_nav == true) {
            navigation_val = {
                nextEl: '.swiper-button-next-' + x,
                prevEl: '.swiper-button-prev-' + x,
            };
        }

        if (!style) {
            style = "slide";
        }

        var margin_val = 30;
        if ($(carouselElement).data('margin') != '' || $(carouselElement).data('margin') == '0') {
            margin_val = $(carouselElement).data('margin');
        }

        var swiper = new Swiper('.element-viewtype-carousel-' + x, {
            loop: loop,
            autoplay: autoplay,
            navigation: navigation_val,
            pagination: pagination_val,
            slidesPerView: columns,
            spaceBetween: margin_val,
            loopedSlides: loopSlide,
            effect: style,
            speed: sl_speed,
            grabCursor: false,
            centeredSlides: val_center,
            breakpoints: {
                1199: {
                    slidesPerView: responsive_items[0],
                },
                991: {
                    slidesPerView: responsive_items[1],
                },
                767: {
                    slidesPerView: responsive_items[2],
                },
                575: {
                    slidesPerView: responsive_items[3],
                },
                0: {
                    slidesPerView: responsive_items[4],
                }
            }
        });
        x = x + 1;
    });

    /*-------------------------------------
    Aos
    -------------------------------------*/
    AOS.init({
        once: true,
    });

    /*-------------------------------------
    Magnific Popup
    -------------------------------------*/
    var i_type = 'image';
    $('.light-box-video, .light-box-video a, a.lightbox').each(function() {
        if ($(this).hasClass('light-box-video')) {
            i_type = 'iframe';
        } else {
            i_type = 'image';
        }
        $(this).magnificPopup({ type: i_type });
    });

    /*-------------------------------------
      Add arrow icon in menu
      -------------------------------------*/
    $(".main-menu ul.navigation li.dropdown").append("<span class='righticon'><i class='ti-angle-down'></i></span>");

    /*-------------------------------------
    Responsive Menu
    -------------------------------------*/
    $('.main-menu ul.navigation li.dropdown .righticon').on('click', function() {
        $(this).siblings().toggleClass('open');
        $(this).find('i').toggleClass('ti-angle-down ti-angle-up');
        return false;
    });

    /*-------------------------------------
    Sticky Header
    -------------------------------------*/
    $(window).scroll(function() {
        var sticky = $('.header__main'),
            scroll = $(window).scrollTop();
        if (scroll >= 90) sticky.addClass('sticky-header');
        else sticky.removeClass('sticky-header');
    });

    /*-------------------------------------
    Scroll To Top
    -------------------------------------*/
    jQuery('body').append('<a href="#" class="scroll__up"><i class="base-icon-up-open-big"></i></a>');
    var btn = jQuery('.scroll__up');
    jQuery(window).scroll(function() {
        if (jQuery(window).scrollTop() > 300) {
            btn.addClass('show');
        } else {
            btn.removeClass('show');
        }
    });
    btn.on('click', function(e) {
        e.preventDefault();
        jQuery('html, body').animate({ scrollTop: 0 }, '300');
    });


    /* =================================================================================================*/

    /*-------------------------------------
    Home Slider
    -------------------------------------*/
    function home_slider() {
        $('.home-slideshow').slick({
            dots: false,
            infinite: true,
            slidesToShow: 1,
            slidesToScroll: 1,
            fade: true,
            arrows: true,
            autoplay: true,
            autoplaySpeed: 8000,
            lazyLoad: 'ondemand'
        });
    }
    home_slider();

    /*-------------------------------------
    Full Size Banner on the Any Screen
    -------------------------------------*/
    $(window).resize(function() {
        var bodyheight = $(this).height() - 35;
        $(".sliderFull .bg-size").height(bodyheight);
    }).resize();



    /*-------------------------------------
    Wow Active
    -------------------------------------*/
    if ($('.wow').length) {
        var wow = new WOW({
            boxClass: 'wow', // animated element css class (default is wow)
            animateClass: 'animated', // animation css class (default is animated)
            offset: 0, // distance to the element when triggering the animation (default is 0)
            mobile: true, // trigger animations on mobile devices (default is true)
            live: true // act on asynchronously loaded content (default is true)
        });
        wow.init();
    };

    /*-------------------------------------
    Odometer
    -------------------------------------*/
    if ($(".odometer").length) {
        var odo = $(".odometer");
        odo.each(function() {
            $(this).appear(function() {
                var countNumber = $(this).attr("data-count");
                $(this).html(countNumber);
            });
        });
    };


    /*-------------------------------------
    Parallax Bg
    -------------------------------------*/
    function parallaxbg_img() {
        $(".parallaxie").parallaxie({
            speed: 0.9,
            offset: 0,
        });
    }
    parallaxbg_img();

    /*-------------------------------------
    Image Background
    -------------------------------------*/
    $(".bg-top").parent().addClass('b-top');
    $(".bg-bottom").parent().addClass('b-bottom');
    $(".bg-center").parent().addClass('b-center');
    $(".bg-left").parent().addClass('b-left');
    $(".bg-right").parent().addClass('b-right');
    $(".bg_size_content").parent().addClass('b_size_content');
    $(".bg-img").parent().addClass('bg-size');
    $(".bg-img.blur-up").parent().addClass('');
    jQuery('.bg-img').each(function() {
        var el = $(this),
            src = el.attr('src'),
            parent = el.parent();
        parent.css({
            'background-image': 'url(' + src + ')',
            'background-size': 'cover',
            'background-position': 'center',
            'background-repeat': 'no-repeat'
        });
        el.hide();
    });

    /*-------------------------------------
    Data Css
    -------------------------------------*/
    $("[data-background").each(function() {
        $(this).css("background-image", "url( " + $(this).attr("data-background") + "  )");
    });

    $("[data-width]").each(function() {
        $(this).css("width", $(this).attr("data-width"));
    });

    $("[data-bg-color]").each(function() {
        $(this).css("background-color", $(this).attr("data-bg-color"));
    });


    /*-------------------------------------
    NiceSelect Plugin
    -------------------------------------*/
    $('select').niceSelect();

    /*-------------------------------------
    DatePicker Plugin
    -------------------------------------*/
    $('[data-toggle="datetimepicker2"]').datepicker();

    /*-------------------------------------
    TimePicker Plugin
    -------------------------------------*/
    $('#time').timepicker();

    /*-------------------------------------
    Faq Accordion
    -------------------------------------*/
    $(".accordion").find(".accordion-title").on("click", function () {
        $(this).toggleClass("active");
        $(this).next().slideToggle("fast");
        $(".accordion-content").not($(this).next()).slideUp("fast");
        $(".accordion-title").not($(this)).removeClass("active");
    });


})($);