<?php
//session_start();
ob_start();
//error_reporting(E_ALL);
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');
include_once('includes/include.php');
include_once('msg/msg.php');
include_once('classes/classes.php');

// Get project_id safely
$project_id = isset($_GET['id']) ? $_GET['id'] : '';

$pro_name = 'Project';
$pro_description = '';
$pro_image = 'assets/images/bg/appointment-bg.jpg'; // default

if ($project_id !== 0) {
$sql_project = "SELECT pro_name, pro_image, pro_description FROM project WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' LIMIT 1";

    $result_project = mysqli_query($link, $sql_project);
    if ($result_project && mysqli_num_rows($result_project) > 0) {
        $project_row = mysqli_fetch_assoc($result_project);
        $pro_name = $project_row['pro_name'] ?? 'Project';
        $pro_description = $project_row['pro_description'] ?? '';
echo "<!-- ";
var_dump($project_row['pro_image']);
echo " -->";

         if (isset($project_row['pro_image']) && trim($project_row['pro_image']) !== '') {
            $pro_image = 'admin/project_img/' . trim($project_row['pro_image']);
         }

    }
}

?>
<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="x-ua-compatible" content="ie=edge">
      <title>Theatre Equipments</title>
      <meta name="description" content="Medsita - Hospital &amp; Clinic HTML5 Template">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <!-- Favicon -->
      <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
      <!-- CSS
         ============================================ -->
      <!-- Vendor CSS -->
      <link rel="stylesheet" href="assets/css/vendors.css">
      <!-- Shortcode CSS -->
      <link rel="stylesheet" href="assets/css/shortcode.css">
      <!-- Default CSS -->
      <link rel="stylesheet" href="assets/css/default.css">
      <!-- Style CSS -->
      <link rel="stylesheet" href="assets/css/style.css">
      <!-- Responsive CSS -->
      <link rel="stylesheet" href="assets/css/responsive.css">


<style>
/* --- General Portfolio Container --- */
.portfolio {
  padding: 30px 0 80px;
  background: #fff;
}

/* Paragraph styling inside portfolio */
.portfolio p {
  color: rgba(255,255,255,0.6);
  margin: 20px 40px;
  letter-spacing: 1px;
  line-height: 1.5em;
}

/* Hide radio inputs for tabs */
.portfolio input[type="radio"] {
  display: none;
}

/* Tabs container styling */
.portfolio .tabs {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  align-items: center;
  gap: 20px;
  margin-bottom: 20px;
  width: 100%;
}

/* Group of tab labels */
.portfolio .tabs .tab-group {
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  gap: 10px;
}

/* Tab labels */
.portfolio .tabs label {
  display: inline-block;
  color: #3f4244;
  text-transform: uppercase;
  text-align: center;
  padding: 10px 18px;
  cursor: pointer;
  margin-bottom: 0 !important;
  user-select: none;
  border-radius: 4px;
  transition: border-color 0.3s ease;
}

/* Highlight selected tab */
.portfolio input[type="radio"]:checked + label {
  border: 1px solid #00e1ff;
  cursor: default;
  background-color: transparent;
}

/* Content container */
.portfolio .content {
  margin-bottom: 29px;
  position: relative;
  overflow: hidden;
}

/* Fix negative margins on labels except first */
.portfolio .tabs label:not(:first-of-type) {
  margin-left: 0;
}

/* Overlay on hover */
.portfolio .tabs .overlay {
  position: absolute;
  top: 100%;
  left: 0;
  width: 100%;
  height: 100%;
  padding-top: 10%;
  background: rgba(0,0,0,0.5);
  color: #fff;
  text-transform: uppercase;
  text-align: center;
  transition: top 0.5s linear;
}

.portfolio .tabs .all .content:hover .overlay {
  top: 0;
}

.portfolio .tabs .overlay span {
  padding: 2px 8px;
  border: 1px solid #fff;
  border-radius: 3px;
  cursor: pointer;
}

.portfolio .tabs .overlay span:hover {
  background: #5CC05C;
  border-color: #5CC05C;
}

/* Product card styles */
.news__card {
  height: 100%;
  display: flex;
  flex-direction: column;
  border: 1px solid #e1e1e1;
  border-radius: 6px;
  overflow: hidden;
  transition: box-shadow 0.3s ease;
}

.post-item {
  display: flex;
  flex-direction: column;
  height: 100%;
}

.featured-wrapper {
  height: 100%;
}

.featured-container {
  aspect-ratio: 7 / 4.5;
  overflow: hidden;
  width: 100%;
}

.featured-wrapper img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  display: block;
}

.news__content {
  flex-grow: 1;
  padding: 15px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  text-align: center;
}

.meta-container {
  max-height: 90px;
  overflow: hidden;
  text-overflow: ellipsis;
}

.post-title a {
  display: inline-block;
  color: #333;
  text-decoration: none;
  transition: color 0.3s ease;
}
.post-title a:hover {
  color: #00e1ff;
}

/* Page title area */
.page-title-area {
  min-height: 250px;
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  margin-bottom: 40px;
}

/* Responsive adjustments */
@media (max-width: 767px) {
  .portfolio .tabs {
    flex-direction: column;
    align-items: stretch;
  }
}
</style>


   </head>
   <body>
      <div id="preLoader" class="pre_loader">
         <div class="preloader__content">
            <img src="assets/images/preloader.gif" alt="">
         </div>
      </div>
      <!-- Page Wrapper -->
      
<main>

<!-- Header -->
<?php include 'navbar.php'; ?>
<!-- Header end -->

<!-- Page title  -->
      <div class="page-title-area breadcrumb__area parallaxie" 
         style="background-image: url('<?= htmlspecialchars($pro_image, ENT_QUOTES) ?>'); min-height:250px; background-size:cover; background-position:center;">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-9">
               <div class="page-title-wrapper text-center">
                  <h3 class="page-title mb-25">Categories</h3>
                  <div class="breadcrumb-menu">
                     <nav aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                        <ul>
                           <li class="trail-item trail-begin"><a href="index.html"><span>Home</span></a></li>
                           <li class="trail-item trail-end"><span>products</span></li>
                        </ul>
                     </nav>
                  </div>
               </div>
               </div>
            </div>
         </div>
      </div>
         <!-- Page title end -->
         <!-- Service Details Content -->
         
<div class="page-content">
<!-- Service -->
<section class="section-lgx">
<div class="container">
<div class="row">
<div class="col-lg-16 service-right-col order-1">
<!-- <img src="assets/images/services/service-detail.jpg" class="w-100 bdr-10" alt=""> -->
<!-- <div class="service-details"> -->

  
<?php

if ($project_id !== '') {
    $sql_project = "SELECT pro_name, pro_description FROM project WHERE project_id = '$project_id' LIMIT 1";
    $result_project = mysqli_query($link, $sql_project);
    if ($result_project && mysqli_num_rows($result_project) > 0) {
        $project_row = mysqli_fetch_assoc($result_project);

        $pro_name = htmlspecialchars($project_row['pro_name']);
        $pro_description = htmlspecialchars($project_row['pro_description']);

        // Output project name and description
        echo '<h2 class="title1" id="te">' . $pro_name . '</h2>';

        // Smart paragraph split (like your requirement)
        if(strlen($pro_description) > 400){
            $pos = strpos($pro_description, '.', 400);
            if($pos !== false){
                echo '<p align="justify">' . trim(substr($pro_description, 0, $pos + 1)) . '</p>';
                echo '<p align="justify">' . trim(substr($pro_description, $pos + 1)) . '</p>';
            } else {
                $half = floor(strlen($pro_description) / 2);
                echo '<p align="justify">' . trim(substr($pro_description, 0, $half)) . '</p>';
                echo '<p align="justify">' . trim(substr($pro_description, $half)) . '</p>';
            }
        } else {
            echo '<p align="justify">' . $pro_description . '</p>';
        }
    } else {
        echo '<h2 class="title1" id="te">Project Not Found</h2>';
        echo '<p align="justify">The requested project does not exist.</p>';
    }
} else {
    echo '<h2 class="title1" id="te">No Project Selected</h2>';
    echo '<p align="justify">Please select a valid project.</p>';
}
?>


<!--start portfolio-->
<!--start portfolio-->
<div class="portfolio">
  <div class="container">
    <div class="tabs">
        <div class="tab-group">
            <input type="radio" value="all" id="all" name="tab" checked/>
            <label for="all">ALL</label>

            <?php
            // Your PHP code for categories here...
            if ($project_id !== '') {
               $query = "SELECT category, category_id FROM category WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' ORDER BY pid";
               $result = mysqli_query($link, $query) or die("DB Error");

               while ($row = mysqli_fetch_assoc($result)) {
                  $catName = htmlspecialchars($row['category']);
                  $catId = 'cat' . htmlspecialchars($row['category_id']);

                  echo '<input type="radio" value="' . $catId . '" id="' . $catId . '" name="tab" />';
                  echo '<label for="' . $catId . '">' . $catName . '</label>';
               }
            }
            ?>
        </div>

    </div>
   </div>

    <div class="content">
      <div class="row">
        <?php
        if ($project_id !== '') {
            $query = "SELECT * FROM product WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' ORDER BY pid";
            $result = mysqli_query($link, $query) or die("DB Error");

         while ($row = mysqli_fetch_assoc($result)) {
            $title = htmlspecialchars($row['title']);
            $image = htmlspecialchars($row['image']);
            $categoryId = htmlspecialchars($row['category_id']);
            $brand = htmlspecialchars($row['brand']);

            // Get the category name for the class (prefix with cat for matching the radio values)
            $catQuery = "SELECT category_id FROM category WHERE category_id = '" . mysqli_real_escape_string($link, $categoryId) . "' LIMIT 1";
            $catResult = mysqli_query($link, $catQuery);
            $catRow = mysqli_fetch_assoc($catResult);
            $catClass = 'cat' . htmlspecialchars($catRow['category_id']); // MUST match radio value

            $productId = htmlspecialchars($row['product_id']);

            // Fetch summary from product_data
            $dataQuery = "SELECT summary FROM product_data WHERE product_id = '" . mysqli_real_escape_string($link, $row['product_id']) . "' LIMIT 1";
            $dataResult = mysqli_query($link, $dataQuery);
            $dataRow = mysqli_fetch_assoc($dataResult);
            $summary = htmlspecialchars($dataRow['summary'] ?? '');

            ?>
            <div class="all <?= $catClass ?> col-xl-4 col-lg-4 col-md-6 mb-40" data-brand="<?= $brand ?>">
               <article class="news__card">
               <div class="post-item">
                  <div class="featured-container">
                     <div class="featured-wrapper">
                     <a href="activityPage.php?productid=<?= $productId ?>">
                        <img src="admin/product_img/<?= $image ?>"
                              alt="<?= $title ?>"
                              class="img-fluid product-img" />
                     </a>
                     </div>
                  </div>
                  <div class="news__content">
                     <div class="meta-container">
                     <h3 class="post-title">
                        <a href="activityPage.php?productid=<?= $productId ?>">
                           <?= $title ?>
                        </a>
                     </h3>
                     <?= $summary ?>
                     </div>
                  </div>
               </div>
               </article>
            </div>
            <?php
            }
        }
        ?>
      </div>
    </div>
  </div>
</div>

</div>
</div>

</div>
<!-- Close .row -->
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Service End -->
</div>
         <!-- Service Details Content End -->

<?php include 'footer.php'; ?>
</main>
      <!-- Page Wrapper End -->
      <!-- JS
         ============================================ -->
      <!-- jQuery JS -->
      <script src="assets/js/jquery.min.js"></script>
      <!-- Vendor JS -->
      <script src="assets/js/vendors.js"></script>
      <!-- Scripts JS -->
      <script src="assets/js/main.js"></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
  function filterProducts() {
    const categoryRadios = document.querySelectorAll('input[name="tab"]');
    let selectedCategory = 'all';

    categoryRadios.forEach(radio => {
      if (radio.checked) selectedCategory = radio.value;
    });

    const products = document.querySelectorAll('.content .row > div');

    products.forEach(product => {
      const productCatClassList = product.classList;
      const show = (selectedCategory === 'all' || productCatClassList.contains(selectedCategory));
      product.style.display = show ? '' : 'none';
    });
  }

  // Category radio buttons
  document.querySelectorAll('input[name="tab"]').forEach(radio => {
    radio.addEventListener('change', filterProducts);
  });

  // Initial filter on page load
  filterProducts();
});
</script>


   </body>
</html>