<?php
//session_start();
ob_start();
//error_reporting(E_ALL);
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');
include_once('includes/include.php');
include_once('msg/msg.php');
include_once('classes/classes.php');

// Get project_id safely
$project_id = isset($_GET['id']) ? $_GET['id'] : '';

$pro_name = 'Project';
$pro_description = '';
$pro_image = 'assets/images/bg/appointment-bg.jpg'; // default

if ($project_id !== 0) {
$sql_project = "SELECT pro_name, pro_image, pro_description FROM project WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' LIMIT 1";

    $result_project = mysqli_query($link, $sql_project);
    if ($result_project && mysqli_num_rows($result_project) > 0) {
        $project_row = mysqli_fetch_assoc($result_project);
        $pro_name = $project_row['pro_name'] ?? 'Project';
        $pro_description = $project_row['pro_description'] ?? '';
echo "<!-- ";
var_dump($project_row['pro_image']);
echo " -->";

         if (isset($project_row['pro_image']) && trim($project_row['pro_image']) !== '') {
            $pro_image = 'admin/project_img/' . trim($project_row['pro_image']);
         }

    }
}

?>
<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="x-ua-compatible" content="ie=edge">
      <title>Theatre Equipments</title>
      <meta name="description" content="Medsita - Hospital &amp; Clinic HTML5 Template">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <!-- Favicon -->
      <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
      <!-- CSS
         ============================================ -->
      <!-- Vendor CSS -->
      <link rel="stylesheet" href="assets/css/vendors.css">
      <!-- Shortcode CSS -->
      <link rel="stylesheet" href="assets/css/shortcode.css">
      <!-- Default CSS -->
      <link rel="stylesheet" href="assets/css/default.css">
      <!-- Style CSS -->
      <link rel="stylesheet" href="assets/css/style.css">
      <!-- Responsive CSS -->
      <link rel="stylesheet" href="assets/css/responsive.css">


<style type="text/css">
/* Portfolio container */
.portfolio {
  padding: 30px 0 80px;
  background: #fff;
}

.portfolio p {
  color: rgba(255, 255, 255, 0.6);
  margin: 20px 40px;
  letter-spacing: 1px;
  line-height: 1.5em;
}

/* Tabs setup */
.portfolio input[type="radio"] {
  display: none;
}

.portfolio .tabs {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  justify-content: space-between;
  align-items: center;
  width: 100%;
  margin-bottom: 20px;
}

.portfolio .tabs label {
  display: inline-block;
  color: #3f4244;
  text-transform: uppercase;
  text-align: center;
  padding: 10px 18px;
  margin-bottom: 0 !important;
  cursor: pointer;
}

.portfolio .tabs label:not(:first-of-type) {
  margin-left: 0;
}

.portfolio .tabs .tab-group {
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  gap: 10px;
}

.portfolio .tabs .all {
  display: none;
  transform-origin: 10% 50%;
}

.portfolio input[type="radio"]:checked + label {
  background-color: transparent;
  border: 1px solid #00e1ff;
  cursor: default;
}

/* Image containers */
.portfolio .tabs .content {
  margin-bottom: 29px;
  position: relative;
  overflow: hidden;
}

.portfolio .tabs .content img {
  height: 190px;
  width: 100%;
  object-fit: cover;
}

/* Overlay */
.portfolio .tabs .overlay {
  position: absolute;
  width: 100%;
  height: 100%;
  top: 100%;
  padding-top: 10%;
  color: #fff;
  text-transform: uppercase;
  text-align: center;
  background: rgba(0, 0, 0, 0.5);
  left: 0;
  transition: all 0.5s linear;
}

.portfolio .tabs .all .content:hover .overlay {
  top: 0;
}

.portfolio .tabs .overlay span {
  padding: 2px 8px;
  border: 1px solid #fff;
  border-radius: 3px;
  cursor: pointer;
}

.portfolio .tabs .overlay span:hover {
  background: #5cc05c;
  border-color: #5cc05c;
}

/* Product image */
.product-img {
  max-width: 100%;
  height: auto;
  object-fit: cover;
  display: block;
}

/* News card styling */
.news__card {
  height: 100%;
  display: flex;
  flex-direction: column;
  border: 1px solid #e1e1e1;
  border-radius: 6px;
  overflow: hidden;
  transition: box-shadow 0.3s ease;
}

.post-item {
  display: flex;
  flex-direction: column;
  height: 100%;
}

.featured-wrapper {
  height: 100%;
}

.featured-container {
  aspect-ratio: 7 / 4.5; /* matches your 700x450 images */
  overflow: hidden;
  width: 100%;
}

.featured-wrapper img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  display: block;
}


.news__content {
  flex-grow: 1;
  padding: 15px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
  text-align: center;
}

.meta-container {
  max-height: 90px;
  overflow: hidden;
  text-overflow: ellipsis;
}

.post-title a {
  display: inline-block;
}

.summary-text {
  margin-top: 8px;
  font-size: 14px;
  color: #555;
}

/* Page title */
.page-title-area {
  min-height: 250px;
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
}

@media (max-width: 767px) {
  .page-title-area {
    margin-bottom: 40px;
  }
}

/* Brand Dropdown */
.brand-dropdown {
  position: relative;
  width: fit-content;
  font-family: Arial, sans-serif;
  flex-shrink: 0;
}

.brand-toggle {
  width: 100%;
  max-width: 300px;
  padding: 10px 18px;
  background-color: transparent;
  border: 1px solid #00e1ff;
  color: #3f4244;
  cursor: pointer;
  text-align: center;
  font-size: 16px;
  border-radius: 4px;
  user-select: none;
  text-transform: uppercase;
  display: inline-block;
  transition: background-color 0.3s ease, color 0.3s ease;
}

.brand-buttons {
  position: absolute;
  top: 100%;
  left: 0;
  width: 100%;
  max-width: 300px;
  border-top: none;
  border-radius: 0 0 4px 4px;
  background-color: white;
  overflow: hidden;
  max-height: 0;
  transition: max-height 0.3s ease;
  z-index: 10;
  box-sizing: border-box;
  border-top: 1px solid transparent;
}

.brand-buttons.show {
  max-height: 500px;
  transition: max-height 0.4s ease;
}

.brand-buttons button {
  width: 100%;
  padding: 6px 12px;
  border: none;
  border-bottom: 1px solid transparent;
  background: none;
  cursor: pointer;
  text-align: left;
  font-size: 15px;
  transition: border-color 0.3s, color 0.3s;
  margin-top: 0;
  box-sizing: border-box;
}

.brand-buttons button:last-child {
  border-bottom: none;
}

.brand-buttons button:hover,
.brand-buttons button.active {
  border-bottom: 1px solid #00e1ff;
  border-top: 1px solid #00e1ff;
  border-left: 1px solid #00e1ff;
  border-right: 1px solid #00e1ff;
  background-color: transparent;
  margin-top: -1px;
  position: relative;
  z-index: 1;
  box-shadow: none;
}

@media (max-width: 767px) {
  /* Stack tabs and brand filter vertically, center aligned */
  .portfolio .tabs {
    flex-direction: column;
    align-items: center;
    gap: 15px;
  }

  /* Tabs group full width and center */
  .portfolio .tabs .tab-group {
    justify-content: center;
    flex-grow: 0;
    width: 100%;
  }

  /* Brand filter wrapper stacked */
  .brand-filter-wrapper {
    flex-direction: column !important;
    align-items: center !important;
    width: 100%;
    gap: 6px;
  }

  /* Filter label full width, center text */
  .filter-label {
    flex-basis: 100%;
    margin-bottom: 0;
    text-align: center;
    white-space: normal;
  }

  /* Brand dropdown full width */
  .brand-dropdown {
    width: 100% !important;
    max-width: 100% !important;
  }

  /* Make the toggle button fill entire container */
  .brand-toggle {
    width: 100% !important;
    max-width: 100% !important;
    text-align: center;
  }

    .brand-buttons {
    width: 100% !important;
    max-width: 100% !important;
  }

  .brand-buttons button {
    width: 100% !important;
    max-width: 100% !important;
    box-sizing: border-box;
  }
}

/* Animation */
@keyframes animateTabe {
  0% {
    opacity: 0;
  }
  100% {
    opacity: 1;
  }
}

.classic-list {
  list-style-type: none;
}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css">


   </head>
   <body>
      <div id="preLoader" class="pre_loader">
         <div class="preloader__content">
            <img src="assets/images/preloader.gif" alt="">
         </div>
      </div>
      <!-- Page Wrapper -->
      
<main>

<!-- Header -->
<?php include 'navbar.php'; ?>
<!-- Header end -->

<!-- Page title  -->
      <div class="page-title-area breadcrumb__area parallaxie" 
         style="background-image: url('<?= htmlspecialchars($pro_image, ENT_QUOTES) ?>'); min-height:250px; background-size:cover; background-position:center;">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-9">
               <div class="page-title-wrapper text-center">
                  <h3 class="page-title mb-25">Categories</h3>
                  <div class="breadcrumb-menu">
                     <nav aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                        <ul>
                           <li class="trail-item trail-begin"><a href="index.html"><span>Home</span></a></li>
                           <li class="trail-item trail-end"><span>products</span></li>
                        </ul>
                     </nav>
                  </div>
               </div>
               </div>
            </div>
         </div>
      </div>
         <!-- Page title end -->
         <!-- Service Details Content -->
         
<div class="page-content">
<!-- Service -->
<section class="section-lgx">
<div class="container">
<div class="row">
<div class="col-lg-16 service-right-col order-1">
<!-- <img src="assets/images/services/service-detail.jpg" class="w-100 bdr-10" alt=""> -->
<!-- <div class="service-details"> -->

  
<?php

if ($project_id !== '') {
    $sql_project = "SELECT pro_name, pro_description FROM project WHERE project_id = '$project_id' LIMIT 1";
    $result_project = mysqli_query($link, $sql_project);
    if ($result_project && mysqli_num_rows($result_project) > 0) {
        $project_row = mysqli_fetch_assoc($result_project);

        $pro_name = htmlspecialchars($project_row['pro_name']);
        $pro_description = htmlspecialchars($project_row['pro_description']);

        // Output project name and description
        echo '<h2 class="title1" id="te">' . $pro_name . '</h2>';

        // Smart paragraph split (like your requirement)
        if(strlen($pro_description) > 400){
            $pos = strpos($pro_description, '.', 400);
            if($pos !== false){
                echo '<p align="justify">' . trim(substr($pro_description, 0, $pos + 1)) . '</p>';
                echo '<p align="justify">' . trim(substr($pro_description, $pos + 1)) . '</p>';
            } else {
                $half = floor(strlen($pro_description) / 2);
                echo '<p align="justify">' . trim(substr($pro_description, 0, $half)) . '</p>';
                echo '<p align="justify">' . trim(substr($pro_description, $half)) . '</p>';
            }
        } else {
            echo '<p align="justify">' . $pro_description . '</p>';
        }
    } else {
        echo '<h2 class="title1" id="te">Project Not Found</h2>';
        echo '<p align="justify">The requested project does not exist.</p>';
    }
} else {
    echo '<h2 class="title1" id="te">No Project Selected</h2>';
    echo '<p align="justify">Please select a valid project.</p>';
}
?>


<!--start portfolio-->
<!--start portfolio-->
<div class="portfolio">
  <div class="container">
    <div class="tabs">
      <div class="tab-group">
        <input type="radio" value="all" id="all" name="tab" checked />
        <label for="all">ALL</label>

        <?php
        if ($project_id !== '') {
            $query = "SELECT category, category_id FROM category WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' ORDER BY pid";
            $result = mysqli_query($link, $query) or die("DB Error");

            while ($row = mysqli_fetch_assoc($result)) {
                $catName = htmlspecialchars($row['category']);
                $catId = 'cat' . htmlspecialchars($row['category_id']);

                echo '<input type="radio" value="' . $catId . '" id="' . $catId . '" name="tab" />';
                echo '<label for="' . $catId . '">' . $catName . '</label>';
            }
        }
        ?>
      </div>

      <!-- Brand Filter Dropdown -->
      <div class="brand-filter-wrapper" style="display:flex; align-items:center; gap:8px;">
      <span class="filter-label" style="font-weight:600; color:#3f4244; text-transform:none;">Filter by:</span>
        <div class="brand-dropdown">
          <button id="brand-toggle" class="brand-toggle">Select Brand ▼</button>
            <div id="brand-buttons" class="brand-buttons hidden">
              <button data-brand="" class="active">All Brands</button>
              <button data-brand="Lowenstein">Lowenstein</button>
              <button data-brand="Merivaara">Merivaara</button>
              <button data-brand="IMO">IMO</button>
              <button data-brand="Weinmaan">Weinmaan</button>
            </div>
        </div>
    </div>
    </div>


    <div class="content">
      <div class="row">
        <?php
        if ($project_id !== '') {
            $query = "SELECT * FROM product WHERE project_id = '" . mysqli_real_escape_string($link, $project_id) . "' ORDER BY pid";
            $result = mysqli_query($link, $query) or die("DB Error");

         while ($row = mysqli_fetch_assoc($result)) {
            $title = htmlspecialchars($row['title']);
            $image = htmlspecialchars($row['image']);
            $categoryId = htmlspecialchars($row['category_id']);
            $brand = htmlspecialchars($row['brand']);

            // Get the category name for the class (prefix with cat for matching the radio values)
            $catQuery = "SELECT category_id FROM category WHERE category_id = '" . mysqli_real_escape_string($link, $categoryId) . "' LIMIT 1";
            $catResult = mysqli_query($link, $catQuery);
            $catRow = mysqli_fetch_assoc($catResult);
            $catClass = 'cat' . htmlspecialchars($catRow['category_id']); // MUST match radio value

            $productId = htmlspecialchars($row['product_id']);

            // Fetch summary from product_data
            $dataQuery = "SELECT summary FROM product_data WHERE product_id = '" . mysqli_real_escape_string($link, $row['product_id']) . "' LIMIT 1";
            $dataResult = mysqli_query($link, $dataQuery);
            $dataRow = mysqli_fetch_assoc($dataResult);
            $summary = htmlspecialchars($dataRow['summary'] ?? '');

            ?>
            <div class="all <?= $catClass ?> col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 mb-40" data-brand="<?= $brand ?>">
               <article class="news__card">
               <div class="post-item">
                  <div class="featured-container">
                     <div class="featured-wrapper">
                     <a href="product.php?productid=<?= $productId ?>">
                        <img src="admin/product_img/<?= $image ?>"
                              alt="<?= $title ?>"
                              class="img-fluid product-img" />
                     </a>
                     </div>
                  </div>
                  <div class="news__content">
                     <div class="meta-container">
                     <h3 class="post-title">
                        <a href="product.php?productid=<?= $productId ?>">
                           <?= $title ?>
                        </a>
                     </h3>
                     <?= $summary ?>
                     </div>
                  </div>
               </div>
               </article>
            </div>
            <?php
            }
        }
        ?>
      </div>
    </div>
  </div>
</div>

</div>
</div>

</div>
<!-- Close .row -->
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Service End -->
</div>
         <!-- Service Details Content End -->

<?php include 'footer.php'; ?>
</main>
      <!-- Page Wrapper End -->
      <!-- JS
         ============================================ -->
      <!-- jQuery JS -->
      <script src="assets/js/jquery.min.js"></script>
      <!-- Vendor JS -->
      <script src="assets/js/vendors.js"></script>
      <!-- Scripts JS -->
      <script src="assets/js/main.js"></script>

<script>
document.addEventListener('DOMContentLoaded', () => {
  let selectedBrand = ''; // empty means no brand filter

  function filterProducts() {
    const categoryRadios = document.querySelectorAll('input[name="tab"]');
    let selectedCategory = 'all';
    categoryRadios.forEach(radio => {
      if (radio.checked) selectedCategory = radio.value;
    });

    const products = document.querySelectorAll('.content .row > div');

    products.forEach(product => {
      const productBrand = (product.getAttribute('data-brand') || '').toLowerCase();
      const productCatClassList = product.classList;

      let show = true;

      if (selectedBrand !== '') {
        // brand filter active, product must match brand AND category (if category != all)
        if (productBrand !== selectedBrand) show = false;
        if (selectedCategory !== 'all' && !productCatClassList.contains(selectedCategory)) show = false;
      } else {
        // no brand filter, filter only by category if not 'all'
        if (selectedCategory !== 'all' && !productCatClassList.contains(selectedCategory)) show = false;
      }

      product.style.display = show ? '' : 'none';
    });
  }

  // Category radio buttons
  document.querySelectorAll('input[name="tab"]').forEach(radio => {
    radio.addEventListener('change', filterProducts);
  });

  // Brand buttons, including "all brands" button
  document.querySelectorAll('#brand-buttons button').forEach(button => {
    button.addEventListener('click', () => {
      selectedBrand = button.getAttribute('data-brand').toLowerCase();

      // Highlight active brand button
      document.querySelectorAll('#brand-buttons button').forEach(btn => btn.classList.remove('active'));
      button.classList.add('active');

      // Update the toggle button text
      const toggleBtn = document.getElementById('brand-toggle');
      if (button.dataset.brand === '') {
        toggleBtn.textContent = 'Select Brand ▼';  // default text for "All Brands"
      } else {
        toggleBtn.textContent = button.textContent + ' ▼';  // selected brand + arrow
      }

      // Hide the dropdown after selection
      document.getElementById('brand-buttons').classList.remove('show');

      filterProducts();
    });
  });

  // Initial filter on page load
  filterProducts();
});


document.addEventListener('DOMContentLoaded', () => {
  const toggleBtn = document.getElementById('brand-toggle');
  const brandButtons = document.getElementById('brand-buttons');

  toggleBtn.addEventListener('click', () => {
    brandButtons.classList.toggle('show');
  });

  // Close dropdown if clicking outside
  document.addEventListener('click', (e) => {
    if (!document.getElementById('brand-dropdown').contains(e.target)) {
      brandButtons.classList.remove('show');
    }
  });
});
</script>



   </body>
</html>