<?php
// session_start();
ob_start();
// error_reporting(E_ALL);
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');
include_once('includes/include.php');
include_once('msg/msg.php');
include_once('classes/classes.php');

$product_id = isset($_GET['id']) ? mysqli_real_escape_string($link, $_GET['id']) : '';
$project_id = '';
$category_name = '';
$categoryImage = 'assets/images/bg/title-bg.jpg';

if ($product_id) {
   $query = "SELECT category_id, project_id FROM product WHERE product_id = '$product_id' LIMIT 1";
   $res = mysqli_query($link, $query);
   if ($res && $row = mysqli_fetch_assoc($res)) {
      $category_id = mysqli_real_escape_string($link, $row['category_id']);
      $project_id = mysqli_real_escape_string($link, $row['project_id']);
      $catQuery = "SELECT image, category FROM category WHERE category_id = '$category_id' LIMIT 1";
      $catRes = mysqli_query($link, $catQuery);
      if ($catRes && $catRow = mysqli_fetch_assoc($catRes)) {
         if (!empty($catRow['image'])) {
            $categoryImage = 'admin/category_img/' . trim($catRow['image']);
         }
         if (!empty($catRow['category'])) {
            $category_name = trim($catRow['category']);
         }
      }
   }
   $productList = [];
   if ($project_id) {
      $productQuery = "SELECT product_id, title FROM product WHERE project_id = '$project_id'";
      $productRes = mysqli_query($link, $productQuery);
      if ($productRes) {
         while ($productRow = mysqli_fetch_assoc($productRes)) {
            $productList[] = $productRow;
         }
      }
   }
}

$productName = $image = $description = $description2 = $projectName = '';
$imageList = [];
if ($product_id) {
   $productQuery = "
        SELECT p.title, p.project_id, p.image, pd.description, pd.description2 
        FROM product p
        LEFT JOIN product_data pd ON p.product_id = pd.product_id
        WHERE p.product_id = '$product_id' 
        LIMIT 1";
   $productResult = mysqli_query($link, $productQuery);
   if ($row = mysqli_fetch_assoc($productResult)) {
      $productName = htmlspecialchars($row['title']);
      $project_id = mysqli_real_escape_string($link, $row['project_id']);
      $image = htmlspecialchars($row['image']);
      $description = $row['description'];
      $description2 = $row['description2'];

      $projQuery = "SELECT pro_name FROM project WHERE project_id = '$project_id' LIMIT 1";
      $projResult = mysqli_query($link, $projQuery);
      if ($projRow = mysqli_fetch_assoc($projResult)) {
         $projectName = htmlspecialchars($projRow['pro_name']);
      }

      $imagesQuery = "SELECT image FROM product_images WHERE product_id = '$product_id' ORDER BY pid ASC";
      $imagesResult = mysqli_query($link, $imagesQuery);
      while ($imgRow = mysqli_fetch_assoc($imagesResult)) {
         $imageList[] = $imgRow['image'];
      }
   }
}

$firstImage = '';
$remainingImages = [];
if (!empty($imageList)) {
   $firstImage = array_shift($imageList);
   $remainingImages = $imageList;
}

define('BASE_URL', (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']));

?>


<!doctype html>
<html lang="en">

<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title><?= !empty($productName) ? $productName : 'BH' ?></title>
   <meta name="description"
      content="<?= !empty($description) ? htmlspecialchars(strip_tags($description)) : 'Default description here' ?>">
   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
   <!-- Favicon -->
   <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
   <!-- CSS
         ============================================ -->
   <!-- Vendor CSS -->
   <link rel="stylesheet" href="assets/css/vendors.css">
   <!-- Shortcode CSS -->
   <link rel="stylesheet" href="assets/css/shortcode.css">
   <!-- Default CSS -->
   <link rel="stylesheet" href="assets/css/default.css">
   <!-- Style CSS -->
   <link rel="stylesheet" href="assets/css/style.css">
   <!-- Responsive CSS -->
   <link rel="stylesheet" href="assets/css/responsive.css">





   <style>
      .carousel-thumb {
         cursor: pointer;
         opacity: 0.6;
         transition: opacity 0.3s;
      }

      .carousel-thumb:hover,
      .carousel-thumb.active {
         opacity: 1;
         /*border: 2px solid #007bff;*/
      }

      .thumbnail-row {
         display: flex;
         justify-content: center;
         gap: 10px;
         margin-top: 15px;
      }

      .thumbnail-row img {
         width: 100px;
         height: auto;
      }
   </style>







</head>

<body>
   <div id="preLoader" class="pre_loader">
      <img src="assets/images/logo.png" alt="">
   </div>
   <!-- Page Wrapper -->
   <main>

      <!-- Header -->
      <?php include 'navbar.php'; ?>
      <!-- Header end -->

      <!-- Page title  -->
      <div class="page-title-area breadcrumb__area parallaxie"
         data-background="<?= htmlspecialchars($categoryImage, ENT_QUOTES) ?>">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-9">
                  <div class="page-title-wrapper text-center">
                     <h3 class="page-title mb-25"><?php echo htmlspecialchars($category_name); ?></h3>
                     <div class="breadcrumb-menu">
                        <nav aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                           <ul>
                              <li class="trail-item trail-begin"><a href="index.html"><span>Home</span></a></li>
                              <li class="trail-item trail-end"><span>products</span></li>
                           </ul>
                        </nav>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- Page title end -->
      <!-- Service Details Content -->
      <div class="page-content">
         <!-- Service -->
         <section class="section-lgx">
            <div class="container">
               <div class="row">
                  <div class="col-lg-4 service-left-col order-2 order-lg-1">
                     <aside class="service-sidebar">

                        <aside class="widget">
                           <div class="service-detail__contact">
                              <div class="contact__icon">
                                 <i class="icon-call3"></i>
                                 <div class="widget__title">Message Us
                                    <h4 class="phn">+94 112 078 200</h4>
                                 </div>
                              </div>
                              <p>For more information about our products, feel free to send us a message via WhatsApp.
                              </p>

                              <div class="d-grid">
                                 <a href="contact-us.html"
                                    class="buttn buttn__white buttn__outlined buttn__rounded">Contact Us</a>
                              </div>
                           </div>
                        </aside>

                        <aside class="widget service__list">
                           <div class="all-service-list">
                              <!-- <h3 class="widget-title">All Theater Products</h3> -->
                              <ul>
                                 <?php if (!empty($productList)): ?>
                                    <?php foreach ($productList as $p): ?>
                                       <li class="<?= ($p['product_id'] === $product_id) ? 'active' : '' ?>">
                                          <a
                                             href="product.php?id=<?= htmlspecialchars($p['product_id'], ENT_QUOTES) ?>&Page=<?= urlencode($p['title']) ?>">
                                             <?= htmlspecialchars($p['title']) ?>
                                          </a>
                                       </li>
                                    <?php endforeach; ?>
                                 <?php else: ?>
                                    <li>No products found in this project.</li>
                                 <?php endif; ?>
                              </ul>
                           </div>
                        </aside>

                     </aside>
                  </div>


                  <?php
                  if (isset($_GET['id'])) {
                     $productId = mysqli_real_escape_string($link, $_GET['id']);

                     // Get product details + descriptions
                     $productQuery = "
        SELECT 
            p.title, 
            p.project_id, 
            p.image,
            pd.description, 
            pd.description2 
        FROM product p
        LEFT JOIN product_data pd ON p.product_id = pd.product_id
        WHERE p.product_id = '$productId' 
        LIMIT 1";

                     $productResult = mysqli_query($link, $productQuery) or die("DB Error");

                     if ($row = mysqli_fetch_assoc($productResult)) {
                        $productName = htmlspecialchars($row['title']);
                        $projectId = mysqli_real_escape_string($link, $row['project_id']);
                        $image = htmlspecialchars($row['image']);
                        $description = $row['description'];
                        $description2 = $row['description2'];

                        // Get project name
                        $projQuery = "SELECT pro_name FROM project WHERE project_id = '$projectId' LIMIT 1";
                        $projResult = mysqli_query($link, $projQuery) or die("DB Error");

                        if ($projRow = mysqli_fetch_assoc($projResult)) {
                           $projectName = htmlspecialchars($projRow['pro_name']);
                           echo '<h4 class="subtitle">Products | <a href="' . BASE_URL . '/products.php?id=' . urlencode($projectId) . '&Page=' . urlencode($projectName) . '">' . htmlspecialchars($projectName) . '</a> | <span>' . htmlspecialchars($productName) . '</span></h4>';


                        } else {
                           echo '<h4 class="subtitle">Products | Unknown Project | <span>' . $productName . '</span></h4>';
                        }

                        // Get additional images
                        $imagesQuery = "
            SELECT image 
            FROM product_images 
            WHERE product_id = '$productId' 
            ORDER BY pid ASC";
                        $imagesResult = mysqli_query($link, $imagesQuery) or die("DB Error");
                     } else {
                        echo '<h4 class="subtitle">Products | Unknown Project | <span>Unknown Product</span></h4>';
                     }
                  } else {
                     echo '<h4 class="subtitle">Products | Unknown Project | <span>Unknown Product</span></h4>';
                  }
                  ?>

                  <div class="col-lg-8 service-right-col order-1">


                     <h2 class="title1" id="te"><?= $productName ?></h2>
                     <p><?= $description ?></p>

                     <?php
                     $imageList = [];
                     if (isset($imagesResult)) {
                        while ($imgRow = mysqli_fetch_assoc($imagesResult)) {
                           $imageList[] = $imgRow['image'];
                        }
                     }

                     $firstImage = '';
                     $remainingImages = [];

                     if (!empty($imageList)) {
                        $firstImage = array_shift($imageList);
                        $remainingImages = $imageList;
                     }
                     ?>
                     <div class="container mt-5">
                        <?php if (!empty($firstImage)): ?>
                           <!-- Carousel -->
                           <div id="mainCarousel" class="carousel slide" data-bs-ride="carousel">
                              <div class="carousel-inner">
                                 <div class="carousel-item active">
                                    <img src="admin/more_product_img/<?= htmlspecialchars($firstImage) ?>"
                                       class="d-block w-100" alt="<?= $productName ?>">
                                 </div>
                                 <?php foreach ($remainingImages as $img): ?>
                                    <div class="carousel-item">
                                       <img src="admin/more_product_img/<?= htmlspecialchars($img) ?>" class="d-block w-100"
                                          alt="<?= $productName ?>">
                                    </div>
                                 <?php endforeach; ?>
                              </div>

                              <!-- Controls -->
                              <button class="carousel-control-prev" type="button" data-bs-target="#mainCarousel"
                                 data-bs-slide="prev">
                                 <span class="carousel-control-prev-icon"></span>
                              </button>
                              <button class="carousel-control-next" type="button" data-bs-target="#mainCarousel"
                                 data-bs-slide="next">
                                 <span class="carousel-control-next-icon"></span>
                              </button>
                           </div>

                           <!-- Thumbnails -->
                           <div class="thumbnail-row mt-3">
                              <img src="admin/more_product_img/<?= htmlspecialchars($firstImage) ?>"
                                 class="carousel-thumb active" data-bs-target="#mainCarousel" data-bs-slide-to="0"
                                 alt="<?= $productName ?>">
                              <?php $thumbIndex = 1; ?>
                              <?php foreach ($remainingImages as $img): ?>
                                 <img src="admin/more_product_img/<?= htmlspecialchars($img) ?>" class="carousel-thumb"
                                    data-bs-target="#mainCarousel" data-bs-slide-to="<?= $thumbIndex ?>"
                                    alt="<?= $productName ?>">
                                 <?php $thumbIndex++; ?>
                              <?php endforeach; ?>
                           </div>
                        </div>
                     <?php endif; ?>







                     <div class="service-page-team">
                        <div class="row">
                           <p><?= $description2 ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </section>
         <!-- Service End -->
      </div>
      <!-- Service Details Content End -->
      <!-- footer --------------------------------------------------------------------------->
      <?php include 'footer.php'; ?>

      <!-- footer End ----------------------------------------------------->
   </main>
   <!-- Page Wrapper End -->
   <!-- JS
         ============================================ -->
   <!-- jQuery JS -->
   <script src="assets/js/jquery.min.js"></script>
   <!-- Vendor JS -->
   <script src="assets/js/vendors.js"></script>
   <!-- Scripts JS -->
   <script src="assets/js/main.js"></script>


   <!-- owl jQuery JS -->

   <!-- Bootstrap JS Bundle -->
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

   <script>
      const thumbnails = document.querySelectorAll('.carousel-thumb');
      const carouselElement = document.querySelector('#mainCarousel');

      carouselElement.addEventListener('slid.bs.carousel', function (e) {
         thumbnails.forEach((thumb, index) => {
            thumb.classList.toggle('active', index === e.to);
         });
      });
   </script>

   <!-- eend owl -->

</body>

</html>