<?php
// session_start();
ob_start();
// error_reporting(E_ALL);
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');
include_once('includes/include.php');
include_once('msg/msg.php');
include_once('classes/classes.php');

// Sanitize GET param early
$product_id = isset($_GET['productid']) ? mysqli_real_escape_string($link, $_GET['productid']) : '';

$project_id = '';
$category_name = '';

if ($product_id) {
    // Get category_id and project_id for this product
    $query = "SELECT category_id, project_id FROM product WHERE product_id = '$product_id' LIMIT 1";
    $res = mysqli_query($link, $query);

    if ($res && $row = mysqli_fetch_assoc($res)) {
        $category_id = mysqli_real_escape_string($link, $row['category_id']);
        $project_id = mysqli_real_escape_string($link, $row['project_id']); // project_id assumed safe as integer or string from DB

        // Get category image and name
        $catQuery = "SELECT image, category FROM category WHERE category_id = '$category_id' LIMIT 1";
        $catRes = mysqli_query($link, $catQuery);
        if ($catRes && $catRow = mysqli_fetch_assoc($catRes)) {
         if (!empty($catRow['image'])) {
            $categoryImage = 'admin/category_img/' . trim($catRow['image']);
         }

            if (!empty($catRow['category'])) {
                $category_name = trim($catRow['category']);
            }
        }
    }

   $productList = [];
   if ($project_id) {
      $productQuery = "SELECT product_id, title FROM product WHERE project_id = '$project_id'";
      $productRes = mysqli_query($link, $productQuery);
      if ($productRes) {
         while ($productRow = mysqli_fetch_assoc($productRes)) {
               $productList[] = $productRow;
         }
      }
   }

}

define('BASE_URL', (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']));
?>

<!doctype html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="x-ua-compatible" content="ie=edge">
      <title>BH</title>
      <meta name="description" content="Medsita - Hospital &amp; Clinic HTML5 Template">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <!-- Favicon -->
      <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
      <!-- CSS
         ============================================ -->
      <!-- Vendor CSS -->
      <link rel="stylesheet" href="assets/css/vendors.css">
      <!-- Shortcode CSS -->
      <link rel="stylesheet" href="assets/css/shortcode.css">
      <!-- Default CSS -->
      <link rel="stylesheet" href="assets/css/default.css">
      <!-- Style CSS -->
      <link rel="stylesheet" href="assets/css/style.css">
      <!-- Responsive CSS -->
      <link rel="stylesheet" href="assets/css/responsive.css">


<style>
   #gallery {
  padding-top: 40px;
  @media screen and (min-width: 991px) {
    padding: 60px 30px 0 30px;
  }
}

.img-wrapper {
  position: relative;
  margin-top: 15px;
  img {
    width: 100%;
  }
}
.img-overlay {
  background: rgba(0,0,0,0.7);
  width: 100%;
  height: 100%;
  position: absolute;
  top: 0;
  left: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  opacity: 0;
  i {
    color: #fff;
    font-size: 3em;
  }
}

#overlay {
  background: rgba(0,0,0,0.7);
  width: 100%;
  height: 100%;
  position: fixed;
  top: 0;
  left: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 999;
  -webkit-user-select: none;
  -moz-user-select: none;    
  -ms-user-select: none; 
  user-select: none; 
  img {
    margin: 0;
    width: 80%;
    height: auto;
    object-fit: contain;
    padding: 5%;
    @media screen and (min-width:768px) {
        width: 60%;
    }
    @media screen and (min-width:1200px) {
        width: 50%;
    }
  }
}

#nextButton {
  color: #fff;
  font-size: 2em;
  transition: opacity 0.8s;
  &:hover {
    opacity: 0.7;
  }
  @media screen and (min-width:768px) {
    font-size: 3em;
  }
}

#prevButton {
  color: #fff;
  font-size: 2em;
  transition: opacity 0.8s;
  &:hover {
    opacity: 0.7;
  }
  @media screen and (min-width:768px) {
    font-size: 3em;
  }
}

#exitButton {
  color: #fff;
  font-size: 2em;
  transition: opacity 0.8s;
  position: absolute;
  top: 15px;
  right: 15px;
  &:hover {
    opacity: 0.7;
  }
  @media screen and (min-width:768px) {
    font-size: 3em;
  }
}
  </style>





      
   </head>
   <body>
      <div id="preLoader" class="pre_loader">
         <div class="preloader__content">
            <img src="assets/images/preloader.gif" alt="">
         </div>
      </div>
      <!-- Page Wrapper -->
      <main>

<!-- Header -->
<?php include 'navbar.php'; ?>
<!-- Header end -->

         <!-- Page title  -->
<div class="page-title-area breadcrumb__area parallaxie"
     data-background="<?= htmlspecialchars($categoryImage, ENT_QUOTES) ?>">


            <div class="container">
               <div class="row justify-content-center">
                  <div class="col-xxl-9">
                     <div class="page-title-wrapper text-center">
                        <h3 class="page-title mb-25"><?php echo htmlspecialchars($category_name); ?></h3>
                        <div class="breadcrumb-menu">
                           <nav aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                              <ul>
                                 <li class="trail-item trail-begin"><a href="index.html"><span>Home</span></a></li>
                                 <li class="trail-item trail-end"><span>products</span></li>
                              </ul>
                           </nav>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <!-- Page title end -->
         <!-- Service Details Content -->
         <div class="page-content">
            <!-- Service -->
            <section class="section-lgx">
               <div class="container">
                  <div class="row">
                     <div class="col-lg-4 service-left-col order-2 order-lg-1">
                        <aside class="service-sidebar">

<aside class="widget">
<div class="service-detail__contact">
<div class="contact__icon">
<i class="icon-call3"></i>
<div class="widget__title">Message Us
<h4 class="phn">+94 112 078 200</h4>
</div>
</div>
<p>For more information about our products, feel free to send us a message via WhatsApp.</p>

<div class="d-grid">
<a href="contact-us.html" class="buttn buttn__white buttn__outlined buttn__rounded">Contact Us</a>
</div>
</div>
</aside>


   <aside class="widget service__list">
   <div class="all-service-list">
   <!-- <h3 class="widget-title">All Theater Products</h3> -->
      <ul>
         <?php if (!empty($productList)): ?>
            <?php foreach ($productList as $p): ?>
               <li class="<?= ($p['product_id'] === $product_id) ? 'active' : '' ?>">
                     <a href="activityPage.php?productid=<?= htmlspecialchars($p['product_id'], ENT_QUOTES) ?>">
                        <?= htmlspecialchars($p['title']) ?>
                     </a>
               </li>
            <?php endforeach; ?>
         <?php else: ?>
            <li>No products found in this project.</li>
         <?php endif; ?>
      </ul>
   </div>
   </aside>
                           
                           

                          
                        </aside>
                     </div>

                     <?php
// Assume $link is your active MySQLi connection

if (isset($_GET['productid'])) {
    $productId = mysqli_real_escape_string($link, $_GET['productid']);

    // Get product details + descriptions
    $productQuery = "
        SELECT 
            p.title, 
            p.project_id, 
            p.image,
            pd.description, 
            pd.description2 
        FROM product p
        LEFT JOIN product_data pd ON p.product_id = pd.product_id
        WHERE p.product_id = '$productId' 
        LIMIT 1";
        
    $productResult = mysqli_query($link, $productQuery) or die("DB Error");

    if ($row = mysqli_fetch_assoc($productResult)) {
        $productName = htmlspecialchars($row['title']);
        $projectId = mysqli_real_escape_string($link, $row['project_id']);
        $image = htmlspecialchars($row['image']);
        $description = $row['description'];
        $description2 = $row['description2'];

        // Get project name
        $projQuery = "SELECT pro_name FROM project WHERE project_id = '$projectId' LIMIT 1";
        $projResult = mysqli_query($link, $projQuery) or die("DB Error");

        if ($projRow = mysqli_fetch_assoc($projResult)) {
            $projectName = htmlspecialchars($projRow['pro_name']);
        } else {
            $projectName = "Unknown Project";
        }

        // Get additional images
        $imagesQuery = "
            SELECT image 
            FROM product_images 
            WHERE product_id = '$productId' 
            ORDER BY pid ASC";
        $imagesResult = mysqli_query($link, $imagesQuery) or die("DB Error");

    } else {
        $productName = "Unknown Product";
        $projectName = "Unknown Project";
        $description = "";
        $description2 = "";
        $image = ""; // fallback or placeholder if you want
        $imagesResult = false;
    }
} else {
    $productName = "Unknown Product";
    $projectName = "Unknown Project";
    $description = "";
    $description2 = "";
    $image = "";
    $imagesResult = false;
}
?>
 <div class="col-lg-8 service-right-col order-1">
                     <h4 class="subtitle">Activities | <a href="<?= BASE_URL ?>/activity.php?id=<?= urlencode($projectId) ?>"><?= htmlspecialchars($projectName) ?></a> | <span><?= htmlspecialchars($productName) ?></span></h4><br><br>

                    
                        
                        
                     <h2 class="title" id="te"><?php echo $productName; ?></h2>
                     <p><?php echo $description;?></p>

<section id="gallery">
  <div class="container">
    <div id="image-gallery">
      <div class="row">
        <?php if ($imagesResult && mysqli_num_rows($imagesResult) > 0): ?>
          <?php while ($imgRow = mysqli_fetch_assoc($imagesResult)): ?>
            <?php $imagePath = 'admin/more_product_img/' . htmlspecialchars($imgRow['image'], ENT_QUOTES); ?>
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12 image">
              <div class="img-wrapper">
                <a href="<?= $imagePath ?>">
                  <img src="<?= $imagePath ?>" class="img-responsive">
                </a>
                <div class="img-overlay">
                  <i class="fa fa-plus-circle" aria-hidden="true"></i>
                </div>
              </div>
            </div>
          <?php endwhile; ?>
        <?php else: ?>
        <?php endif; ?>
      </div><!-- End row -->
    </div><!-- End image gallery -->
  </div><!-- End container --> 
</section>

<p><?php echo $description2;?></p>

                         </div>
                              </div>
                           </div>
                        </div>
                     </div>
            </section>
            <!-- Service End -->
         </div>
         <!-- Service Details Content End -->
         <!-- footer --------------------------------------------------------------------------->
         <?php include 'footer.php'; ?>

<!-- footer End ----------------------------------------------------->
      </main>
      <!-- Page Wrapper End -->
      <!-- JS
         ============================================ -->
      <!-- jQuery JS -->
      <script src="assets/js/jquery.min.js"></script>
      <!-- Vendor JS -->
      <script src="assets/js/vendors.js"></script>
      <!-- Scripts JS -->
      <script src="assets/js/main.js"></script>


<!-- owl jQuery JS -->

<!-- Bootstrap JS Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>


<script>
// Gallery image hover
$( ".img-wrapper" ).hover(
  function() {
    $(this).find(".img-overlay").animate({opacity: 1}, 600);
  }, function() {
    $(this).find(".img-overlay").animate({opacity: 0}, 600);
  }
);

// Lightbox
var $overlay = $('<div id="overlay"></div>');
var $image = $("<img>");
var $prevButton = $('<div id="prevButton"><i class="fa fa-chevron-left"></i></div>');
var $nextButton = $('<div id="nextButton"><i class="fa fa-chevron-right"></i></div>');
var $exitButton = $('<div id="exitButton"><i class="fa fa-times"></i></div>');

// Add overlay
$overlay.append($image).prepend($prevButton).append($nextButton).append($exitButton);
$("#gallery").append($overlay);

// Hide overlay on default
$overlay.hide();

// When an image is clicked
$(".img-overlay").click(function(event) {
  // Prevents default behavior
  event.preventDefault();
  // Adds href attribute to variable
  var imageLocation = $(this).prev().attr("href");
  // Add the image src to $image
  $image.attr("src", imageLocation);
  // Fade in the overlay
  $overlay.fadeIn("slow");
});

// When the overlay is clicked
$overlay.click(function() {
  // Fade out the overlay
  $(this).fadeOut("slow");
});

// When next button is clicked
$nextButton.click(function(event) {
  // Hide the current image
  $("#overlay img").hide();
  // Overlay image location
  var $currentImgSrc = $("#overlay img").attr("src");
  // Image with matching location of the overlay image
  var $currentImg = $('#image-gallery img[src="' + $currentImgSrc + '"]');
  // Finds the next image
  var $nextImg = $($currentImg.closest(".image").next().find("img"));
  // All of the images in the gallery
  var $images = $("#image-gallery img");
  // If there is a next image
  if ($nextImg.length > 0) { 
    // Fade in the next image
    $("#overlay img").attr("src", $nextImg.attr("src")).fadeIn(800);
  } else {
    // Otherwise fade in the first image
    $("#overlay img").attr("src", $($images[0]).attr("src")).fadeIn(800);
  }
  // Prevents overlay from being hidden
  event.stopPropagation();
});

// When previous button is clicked
$prevButton.click(function(event) {
  // Hide the current image
  $("#overlay img").hide();
  // Overlay image location
  var $currentImgSrc = $("#overlay img").attr("src");
  // Image with matching location of the overlay image
  var $currentImg = $('#image-gallery img[src="' + $currentImgSrc + '"]');
  // Finds the next image
  var $nextImg = $($currentImg.closest(".image").prev().find("img"));
  // Fade in the next image
  $("#overlay img").attr("src", $nextImg.attr("src")).fadeIn(800);
  // Prevents overlay from being hidden
  event.stopPropagation();
});

// When the exit button is clicked
$exitButton.click(function() {
  // Fade out the overlay
  $("#overlay").fadeOut("slow");
});
</script>


<!-- eend owl -->

   </body>
</html>