<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/autoload.php'; 
require '../php/smtp_config.php';

header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $errors = [];

    // Get and sanitize inputs
    $name = strip_tags(trim($_POST["name"] ?? ''));
    $email = filter_var(trim($_POST["email"] ?? ''), FILTER_SANITIZE_EMAIL);
    $phone = strip_tags(trim($_POST["phone"] ?? ''));
    $subject = strip_tags(trim($_POST["subject"] ?? ''));
    $message = strip_tags(trim($_POST["message"] ?? ''));

    // Validate inputs
    if (empty($name)) {
        $errors['name'] = "Name is required.";
    }

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors['email'] = "A valid email is required.";
    }

    if (empty($phone)) {
        $errors['phone'] = "Phone number is required.";
    }

    if (empty($subject)) {
        $errors['subject'] = "Please select a subject.";
    }

    if (empty($message)) {
        $errors['message'] = "Message cannot be empty.";
    }

    // Return errors if found
    if (!empty($errors)) {
        echo json_encode([
            'status' => 'error',
            'errors' => $errors
        ]);
        exit;
    }

    try {
        $mail = setupMailer();

        // Recipients
        $mail->setFrom('form@harshatailors.com', 'Website Inquiry Form');
        $mail->addAddress('kushannadeesh49@gmail.com', 'Site Admin');

        // Email content
        $mail->isHTML(false);
        $mail->Subject = "New Contact Message - " . $subject;
        $mail->Body =
            "Name: $name\n" .
            "Email: $email\n" .
            "Phone: $phone\n" .
            "Subject: $subject\n\n" .
            "Message:\n$message";

        $mail->send();

        echo json_encode([
            'status' => 'success'
        ]);

    } catch (Exception $e) {
        echo json_encode([
            'status' => 'fail',
            'message' => "Mailer Error: " . $mail->ErrorInfo
        ]);
    }

} else {
    echo json_encode([
        'status' => 'fail',
        'message' => "Invalid request method."
    ]);
}
