<?php
// session_start();
ob_start();
// error_reporting(E_ALL);
include_once('sql/sql.php');
include_once('cnxn/cnxn.php');
include_once('includes/include.php');
include_once('msg/msg.php');
include_once('classes/classes.php');

// Sanitize GET param early
$product_id = isset($_GET['id']) ? mysqli_real_escape_string($link, $_GET['id']) : '';

$project_id = '';
$category_name = '';

if ($product_id) {
   // Get category_id and project_id for this product
   $query = "SELECT category_id, project_id FROM product WHERE product_id = '$product_id' LIMIT 1";
   $res = mysqli_query($link, $query);

   if ($res && $row = mysqli_fetch_assoc($res)) {
      $category_id = mysqli_real_escape_string($link, $row['category_id']);
      $project_id = mysqli_real_escape_string($link, $row['project_id']); // project_id assumed safe as integer or string from DB

      // Get category image and name
      $catQuery = "SELECT image, category FROM category WHERE category_id = '$category_id' LIMIT 1";
      $catRes = mysqli_query($link, $catQuery);
      if ($catRes && $catRow = mysqli_fetch_assoc($catRes)) {
         if (!empty($catRow['image'])) {
            $categoryImage = 'admin/category_img/' . trim($catRow['image']);
         }

         if (!empty($catRow['category'])) {
            $category_name = trim($catRow['category']);
         }
      }
   }

   $productList = [];
   if ($project_id) {
      $productQuery = "SELECT product_id, title FROM product WHERE project_id = '$project_id'";
      $productRes = mysqli_query($link, $productQuery);
      if ($productRes) {
         while ($productRow = mysqli_fetch_assoc($productRes)) {
            $productList[] = $productRow;
         }
      }
   }

   $productTitle = "Unknown Product";
   $productDescription = "Default description here";

   if ($product_id) {
      $productDetailsQuery = "
          SELECT p.title, pd.description 
          FROM product p
          LEFT JOIN product_data pd ON p.product_id = pd.product_id
          WHERE p.product_id = '$product_id'
          LIMIT 1";
      $productDetailsResult = mysqli_query($link, $productDetailsQuery);
      if ($productDetailsResult && $detailsRow = mysqli_fetch_assoc($productDetailsResult)) {
         if (!empty($detailsRow['title'])) {
            $productTitle = htmlspecialchars($detailsRow['title']);
         }
         if (!empty($detailsRow['description'])) {
            $productDescription = htmlspecialchars($detailsRow['description']);
         }
      }
   }

}

define('BASE_URL', (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']));
?>

<!doctype html>
<html lang="en">

<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title><?= $productTitle ?? 'BH' ?></title>
   <meta name="description" content="<?= $productDescription ?? 'Default description here' ?>">
   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
   <!-- Favicon -->
   <link rel="shortcut icon" type="image/x-icon" href="assets/images/favicon.ico">
   <!-- CSS
         ============================================ -->
   <!-- Vendor CSS -->

   <link rel="stylesheet" href="assets/css/vendors.css">
   <!-- Shortcode CSS -->
   <link rel="stylesheet" href="assets/css/shortcode.css">
   <!-- Default CSS -->
   <link rel="stylesheet" href="assets/css/default.css">
   <!-- Style CSS -->
   <link rel="stylesheet" href="assets/css/style.css">
   <!-- Responsive CSS -->
   <link rel="stylesheet" href="assets/css/responsive.css">

   <!-- Fancybox CSS -->
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox/fancybox.css" />

   <style>
      .gallery-img {
         width: 100%;
         height: auto;
         border-radius: 10px;
         box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
         transition: transform 0.3s ease;
      }

      .gallery-img:hover {
         transform: scale(1.02);
      }
   </style>
</head>

<body>
   <div id="preLoader" class="pre_loader">
      <img src="assets/images/logo.png" alt="">
   </div>
   <!-- Page Wrapper -->

   <main>
      <!-- Header -->
      <header class="header-wrap">
         <?php include 'navbar.php'; ?>
      </header>
      <!-- Header end -->
      <!-- Page title  -->
      <div class="page-title-area breadcrumb__area parallaxie"
         data-background="<?= htmlspecialchars($categoryImage, ENT_QUOTES) ?>">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-9">
                  <div class="page-title-wrapper text-center">
                     <h3 class="page-title mb-25"><?php echo htmlspecialchars($category_name); ?></h3>
                     <div class="breadcrumb-menu">
                        <nav aria-label="Breadcrumbs" class="breadcrumb-trail breadcrumbs">
                           <ul>
                              <li class="trail-item trail-begin"><a href="index.html"><span>Home</span></a></li>
                              <li class="trail-item trail-end"><span>Activities</span></li>
                           </ul>
                        </nav>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <!-- Page title end -->

      <!-- Service Details Content -->

      <div class="page-content">
         <!-- Service -->
         <section class="section-lgx">
            <div class="container">
               <div class="row">
                  <div class="col-lg-4 service-left-col order-2 order-lg-1">
                     <aside class="service-sidebar">

                        <aside class="widget">
                           <div class="service-detail__contact">
                              <div class="contact__icon">
                                 <i class="icon-call3"></i>
                                 <div class="widget__title">Message Us
                                    <h4 class="phn">+94 112 078 200</h4>
                                 </div>
                              </div>
                              <p>For more information about our products, feel free to send us a message via WhatsApp.
                              </p>
                              <div class="d-grid">
                                 <a href="contact-us.html"
                                    class="buttn buttn__white buttn__outlined buttn__rounded">Contact Us</a>
                              </div>
                           </div>
                        </aside>


                        <aside class="widget service__list">
                           <div class="all-service-list">
                              <ul>
                                 <?php if (!empty($productList)): ?>
                                    <?php foreach ($productList as $p): ?>
                                       <li class="<?= ($p['product_id'] === $product_id) ? 'active' : '' ?>">
                                          <a
                                             href="activity.php?id=<?= htmlspecialchars($p['product_id'], ENT_QUOTES) ?>&Page=<?= urlencode($p['title']) ?>">
                                             <?= htmlspecialchars($p['title']) ?>
                                          </a>
                                       </li>
                                    <?php endforeach; ?>
                                 <?php else: ?>
                                    <li>No products found in this project.</li>
                                 <?php endif; ?>
                              </ul>
                           </div>
                        </aside>
                     </aside>
                  </div>

                  <?php
                  // Assume $link is your active MySQLi connection
                  
                  if (isset($_GET['id'])) {
                     $productId = mysqli_real_escape_string($link, $_GET['id']);

                     // Get product details + descriptions
                     $productQuery = "
        SELECT 
            p.title, 
            p.project_id, 
            p.image,
            pd.description, 
            pd.description2 
        FROM product p
        LEFT JOIN product_data pd ON p.product_id = pd.product_id
        WHERE p.product_id = '$productId' 
        LIMIT 1";

                     $productResult = mysqli_query($link, $productQuery) or die("DB Error");

                     if ($row = mysqli_fetch_assoc($productResult)) {
                        $productName = htmlspecialchars($row['title']);
                        $projectId = mysqli_real_escape_string($link, $row['project_id']);
                        $image = htmlspecialchars($row['image']);
                        $description = $row['description'];
                        $description2 = $row['description2'];

                        // Get project name
                        $projQuery = "SELECT pro_name FROM project WHERE project_id = '$projectId' LIMIT 1";
                        $projResult = mysqli_query($link, $projQuery) or die("DB Error");

                        if ($projRow = mysqli_fetch_assoc($projResult)) {
                           $projectName = htmlspecialchars($projRow['pro_name']);
                        } else {
                           $projectName = "Unknown Project";
                        }

                        // Get additional images
                        $imagesQuery = "
            SELECT image 
            FROM product_images 
            WHERE product_id = '$productId' 
            ORDER BY pid ASC";
                        $imagesResult = mysqli_query($link, $imagesQuery) or die("DB Error");

                     } else {
                        $productName = "Unknown Product";
                        $projectName = "Unknown Project";
                        $description = "";
                        $description2 = "";
                        $image = ""; // fallback or placeholder if you want
                        $imagesResult = false;
                     }
                  } else {
                     $productName = "Unknown Product";
                     $projectName = "Unknown Project";
                     $description = "";
                     $description2 = "";
                     $image = "";
                     $imagesResult = false;
                  }
                  ?>
                  <h4 class="subtitle">Activities |
                     <a
                        href="<?= BASE_URL ?>/activities.php?id=<?= urlencode($projectId) ?>&Page=<?= urlencode($projectName) ?>">
                        <?= htmlspecialchars($projectName) ?>
                     </a> | <span><?= htmlspecialchars($productName) ?></span>
                  </h4>

                  <div class="col-lg-8 service-right-col order-1">
                     <h2 class="title" style="color:#ba2f32;" id="te"><?php echo $productName; ?></h2>
                     <p><?php echo $description; ?></p>
                     <div class="row g-3 mb-4">
                        <?php
                        $index = 1;
                        if ($imagesResult && mysqli_num_rows($imagesResult) > 0):
                           while ($imgRow = mysqli_fetch_assoc($imagesResult)):
                              $imagePath = 'admin/more_product_img/' . htmlspecialchars($imgRow['image'], ENT_QUOTES);
                              ?>
                              <div class="col-sm-6 col-md-4">
                                 <a href="<?= $imagePath ?>" data-fancybox="gallery" data-caption="">
                                    <img src="<?= $imagePath ?>" alt="<?php echo $imgRow['image'] ?>" class="gallery-img" />
                                 </a>
                              </div>
                              <?php
                              $index++;
                           endwhile;
                        endif;
                        ?>
                     </div>
                  </div>
               </div>
            </div>
      </div>
      </div>
      </div>
      </div>
      </section>
      <!-- Service End -->
      </div>
      <!-- Service Details Content End -->
      <!-- footer --------------------------------------------------------------------------->
      <?php include 'footer.php'; ?>
      <!-- footer End ----------------------------------------------------->
   </main>
   <!-- Page Wrapper End -->
   <!-- JS
         ============================================ -->
   <!-- jQuery JS -->
   <script src="assets/js/jquery.min.js"></script>
   <!-- Vendor JS -->
   <script src="assets/js/vendors.js"></script>
   <!-- Scripts JS -->
   <script src="assets/js/main.js"></script>
   <!-- owl jQuery JS -->
   <!-- Bootstrap JS Bundle -->

   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
   <!-- Fancybox JS -->
   <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox/fancybox.umd.js"></script>

   <!-- Fancybox Init (Optional customization) -->
   <script>
      Fancybox.bind("[data-fancybox='gallery']", {
         Thumbs: {
            autoStart: true,
         },
         Toolbar: {
            display: [
               { id: "counter", position: "center" },
               "zoom",
               "slideshow",
               "fullscreen",
               "thumbs",
               "close",
            ],
         },
      });
   </script>


   <!-- <script>

      let currentIndex = 1;

      let images = <?php
      if ($imagesResult && mysqli_num_rows($imagesResult) > 0):
         mysqli_data_seek($imagesResult, 0);
         $images = [];
         while ($imgRow = mysqli_fetch_assoc($imagesResult)) {
            $images[] = 'admin/more_product_img/' . htmlspecialchars($imgRow['image'], ENT_QUOTES);
         }
         echo json_encode($images); // This echoes a valid JS array
      else:
         echo '[]'; // If no images found
      endif;
      ?>;

      function openLightbox() {
         document.getElementById("lightbox").style.display = "block";
      }

      function closeLightbox() {
         document.getElementById("lightbox").style.display = "none";
      }

      function currentSlide(index) {
         currentIndex = index;
         showSlide(currentIndex);

      }

      function changeSlide(n) {
         currentIndex += n;
         if (currentIndex > images.length) currentIndex = 1;
         if (currentIndex < 1) currentIndex = images.length;
         showSlide(currentIndex);

      }

      function showSlide(index) {
         document.getElementById("lightboxImage").src = images[index - 1];
      }
   </script> -->
</body>

</html>