<?php

class SimpleImage {

   

   var $image;

   var $image_type;

 

   function load($filename) {

      $image_info = getimagesize($filename);

      $this->image_type = $image_info[2];

      if( $this->image_type == IMAGETYPE_JPEG ) {

         $this->image = imagecreatefromjpeg($filename);

      } elseif( $this->image_type == IMAGETYPE_GIF ) {

         $this->image = imagecreatefromgif($filename);

      } elseif( $this->image_type == IMAGETYPE_PNG ) {

         $this->image = imagecreatefrompng($filename);

      }

   }

   function save($filename, $image_type=IMAGETYPE_JPEG, $compression=75, $permissions=null) {

      if( $image_type == IMAGETYPE_JPEG ) {

         imagejpeg($this->image,$filename,$compression);

      } elseif( $image_type == IMAGETYPE_GIF ) {

         imagegif($this->image,$filename);         

      } elseif( $image_type == IMAGETYPE_PNG ) {

         imagepng($this->image,$filename);

      }   

      if( $permissions != null) {

         chmod($filename,$permissions);

      }

   }

   function output($image_type=IMAGETYPE_JPEG) {

      if( $image_type == IMAGETYPE_JPEG ) {

         imagejpeg($this->image);

      } elseif( $image_type == IMAGETYPE_GIF ) {

         imagegif($this->image);         

      } elseif( $image_type == IMAGETYPE_PNG ) {

         imagepng($this->image);

      }   

   }

   function getWidth() {

      return imagesx($this->image);

   }

   function getHeight() {

      return imagesy($this->image);

   }

   function resizeToHeight($height) {

      $ratio = $height / $this->getHeight();

      $width = $this->getWidth() * $ratio;

      $this->resize($width,$height);

   }

   function resizeToWidth($width) {

      $ratio = $width / $this->getWidth();

      $height = $this->getheight() * $ratio;

      $this->resize($width,$height);

   }

   function scale($scale) {

      $width = $this->getWidth() * $scale/100;

      $height = $this->getheight() * $scale/100; 

      $this->resize($width,$height);

   }

   function resize($width,$height) {

      $new_image = imagecreatetruecolor($width, $height);

      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());

      $this->image = $new_image;   

   }      

}







/*   $image = new SimpleImage();

   $image->load('image.jpg');

   $image->resizeToWidth(250);

   $image->save('image1.jpg');

*/





/*************************************************************************

php easy :: pagination scripts set - Version Three

==========================================================================

Author:      php easy code, www.phpeasycode.com

Web Site:    //www.phpeasycode.com

Contact:     webmaster@phpeasycode.com

*************************************************************************/

function paginate_three($reload, $page, $tpages, $adjacents) {

	

	$prevlabel = "&lsaquo; Prev";

	$nextlabel = "Next &rsaquo;";

	

	$out = "<div >\n";

	

	// previous

	if($page==1) {

		$out.= "<span class='pagination'>" . $prevlabel . "</span>\n";

	}

	elseif($page==2) {

		$out.= "<a href=\"" . $reload . "\" >" . $prevlabel . "</a>\n";

	}

	else {

		$out.= "<a href=\"" . $reload . "&amp;page=" . ($page-1) . "\" >" . $prevlabel . "</a>\n";

	}

	

	// first

	if($page>($adjacents+1)) {

		$out.= "<a href=\"" . $reload . "\" >1</a>\n";

	}

	

	// interval

	if($page>($adjacents+2)) {

		$out.= "...\n";

	}

	

	// pages

	$pmin = ($page>$adjacents) ? ($page-$adjacents) : 1;

	$pmax = ($page<($tpages-$adjacents)) ? ($page+$adjacents) : $tpages;

	for($i=$pmin; $i<=$pmax; $i++) {

		if($i==$page) {

			$out.= "<span >" . $i . "</span>\n";

		}

		elseif($i==1) {

			$out.= "<a href=\"" . $reload . "\" >" . $i . "</a>\n";

		}

		else {

			$out.= "<a href=\"" . $reload . "&amp;page=" . $i . "\" >" . $i . "</a>\n";

		}

	}

	

	// interval

	if($page<($tpages-$adjacents-1)) {

		$out.= "...\n";

	}

	

	// last

	if($page<($tpages-$adjacents)) {

		$out.= "<a href=\"" . $reload . "&amp;page=" . $tpages . "\" >" . $tpages . "</a>\n";

	}

	

	// next

	if($page<$tpages) {

		$out.= "<a href=\"" . $reload . "&amp;page=" . ($page+1) . "\" >" . $nextlabel . "</a>\n";

	}

	else {

		$out.= "<span>" . $nextlabel . "</span>\n";

	}

	

	$out.= "</div>";

	

	return $out;

}









?>

