$(document).ready(function () {
    $("#contact-form").on("submit", function (e) {
        e.preventDefault();

        // Clear previous messages and errors
        $(".error_msg").text("");
        $("#form-message")
            .removeClass("alert-success alert-danger")
            .addClass("d-none")
            .text("");

        $(".loading").show();

        var formData = $(this).serialize();

        $.ajax({
            type: "POST",
            url: "php/ajax_sendmail.php",
            data: formData,
            dataType: "json",
            success: function (response) {
                $(".loading").hide();

                if (response.status === "success") {
                    $("#form-message")
                        .removeClass("d-none")
                        .addClass("alert alert-success")
                        .text("Your message has been sent successfully!");

                    $("#contact-form")[0].reset();

                    // Hide message after 5 seconds
                    setTimeout(function () {
                        $("#form-message").fadeOut("slow", function () {
                            $(this).addClass("d-none").show().text("");
                        });
                    }, 5000);
                } else if (response.status === "error") {
                    $.each(response.errors, function (key, val) {
                        $("#" + key + "_error").text(val);
                    });
                } else {
                    $("#form-message")
                        .removeClass("d-none")
                        .addClass("alert alert-danger")
                        .text("Something went wrong. Please try again.");

                    setTimeout(function () {
                        $("#form-message").fadeOut("slow", function () {
                            $(this).addClass("d-none").show().text("");
                        });
                    }, 5000);
                }
            },
            error: function () {
                $(".loading").hide();

                $("#form-message")
                    .removeClass("d-none")
                    .addClass("alert alert-danger")
                    .text("Server error. Please try again later.");

                setTimeout(function () {
                    $("#form-message").fadeOut("slow", function () {
                        $(this).addClass("d-none").show().text("");
                    });
                }, 5000);
            }
        });
    });

    $(".loading").hide();
});
