 document.addEventListener("DOMContentLoaded", () => {
        const filter = document.getElementById("filter");

        const gridContainer = document.getElementById("productGrid");
        const paginationGrid = document.querySelector("#paginationGrid ul");
        let currentPageGrid = 1;
        const gridPerPage = 6;
        const gridItemsAll = Array.from(gridContainer.children);

        const listContainer = document.getElementById("productList");
        const paginationList = document.querySelector("#paginationList ul");
        let currentPageList = 1;
        const listPerPage = 3;
        const listItemsAll = Array.from(listContainer.children);

        function renderPagination(
          totalItems,
          page,
          perPage,
          paginationEl,
          onPageClick
        ) {
          paginationEl.innerHTML = "";
          const pages = Math.ceil(totalItems / perPage);

          for (let i = 1; i <= pages; i++) {
            const li = document.createElement("li");
            if (i === page) li.classList.add("active");

            const a = document.createElement("a");
            a.href = "#";
            a.textContent = i;
            a.addEventListener("click", (e) => {
              e.preventDefault();
              onPageClick(i);
            });

            li.appendChild(a);
            paginationEl.appendChild(li);
          }

          if (page < pages) {
            const liNext = document.createElement("li");
            const aNext = document.createElement("a");
            aNext.href = "#";
            aNext.innerHTML = `<i class="sp-arrow-bold-right"></i>`;
            aNext.addEventListener("click", (e) => {
              e.preventDefault();
              onPageClick(page + 1);
            });
            liNext.appendChild(aNext);
            paginationEl.appendChild(liNext);
          }
        }

        function renderGrid(items, page = 1) {
          gridContainer.innerHTML = "";
          const start = (page - 1) * gridPerPage;
          const paginatedItems = items.slice(start, start + gridPerPage);
          paginatedItems.forEach((item) => gridContainer.appendChild(item));
          renderPagination(
            items.length,
            page,
            gridPerPage,
            paginationGrid,
            setGridPage
          );
        }

        function applyGridFilter() {
          const value = filter.value;
          const filtered = value
            ? gridItemsAll.filter(
                (item) =>
                  item.querySelector(".product-brief h2").textContent.trim() ===
                  value
              )
            : gridItemsAll;
          renderGrid(filtered, currentPageGrid);
        }

        function setGridPage(page) {
          currentPageGrid = page;
          applyGridFilter();
        }

        function renderList(items, page = 1) {
          listContainer.innerHTML = "";
          const start = (page - 1) * listPerPage;
          const paginatedItems = items.slice(start, start + listPerPage);
          paginatedItems.forEach((item) => listContainer.appendChild(item));
          renderPagination(
            items.length,
            page,
            listPerPage,
            paginationList,
            setListPage
          );
        }

        function applyListFilter() {
          const value = filter.value;
          const filtered = value
            ? listItemsAll.filter(
                (item) =>
                  item.querySelector(".product-brief h2").textContent.trim() ===
                  value
              )
            : listItemsAll;
          renderList(filtered, currentPageList);
        }

        function setListPage(page) {
          currentPageList = page;
          applyListFilter();
        }

        filter.addEventListener("change", () => {
          currentPageGrid = 1;
          currentPageList = 1;
          if (
            document.querySelector("#grid-view").classList.contains("active")
          ) {
            applyGridFilter();
          } else if (
            document.querySelector("#list-view").classList.contains("active")
          ) {
            applyListFilter();
          }
        });

        const tabs = document.querySelectorAll('[data-bs-toggle="tab"]');
        tabs.forEach((tab) => {
          tab.addEventListener("shown.bs.tab", (e) => {
            if (e.target.getAttribute("href") === "#grid-view") {
              currentPageGrid = 1;
              applyGridFilter();
              paginationGrid.parentElement.style.display = "block";
              paginationList.parentElement.style.display = "none";
            } else if (e.target.getAttribute("href") === "#list-view") {
              currentPageList = 1;
              applyListFilter();
              paginationGrid.parentElement.style.display = "none";
              paginationList.parentElement.style.display = "block";
            }
          });
        });

        if (tabs.length === 0) {
          document.querySelectorAll('[role="tab"]').forEach((tab) => {
            tab.addEventListener("click", () => {
              setTimeout(() => {
                if (
                  document
                    .querySelector("#grid-view")
                    .classList.contains("active")
                ) {
                  currentPageGrid = 1;
                  applyGridFilter();
                  paginationGrid.parentElement.style.display = "block";
                  paginationList.parentElement.style.display = "none";
                } else if (
                  document
                    .querySelector("#list-view")
                    .classList.contains("active")
                ) {
                  currentPageList = 1;
                  applyListFilter();
                  paginationGrid.parentElement.style.display = "none";
                  paginationList.parentElement.style.display = "block";
                }
              }, 200);
            });
          });
        }

        if (document.querySelector("#grid-view").classList.contains("active")) {
          applyGridFilter();
          paginationGrid.parentElement.style.display = "block";
          paginationList.parentElement.style.display = "none";
        } else {
          applyListFilter();
          paginationGrid.parentElement.style.display = "none";
          paginationList.parentElement.style.display = "block";
        }
      });

      document.addEventListener("DOMContentLoaded", function () {
        const mainImage = document.getElementById("mainProductImage");
        const thumbnails = document.querySelectorAll(".thumbnail");

        thumbnails.forEach(function (thumb) {
          thumb.addEventListener("click", function () {
            mainImage.src = this.src;

            thumbnails.forEach((t) => (t.style.borderColor = "transparent"));
            this.style.borderColor = "#ec1d24";
          });
        });
        if (thumbnails.length > 0) thumbnails[0].style.borderColor = "#ec1d24";
      });